/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.XMLEncodeable;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import org.w3c.dom.Node;

public class LocalizableText
implements Serializable,
XMLEncodeable {
    private String bundleName = null;
    private String key = "";
    private Object[] subst = null;
    private static final long serialVersionUID = -7274201995970290999L;

    public LocalizableText(String bundleName, String key, Object[] subst) {
        this.bundleName = bundleName;
        this.key = key;
        this.subst = subst;
    }

    public LocalizableText(String bundleName, String key) {
        this(bundleName, key, null);
    }

    public LocalizableText(String text) {
        this(null, text, null);
    }

    public LocalizableText() {
    }

    public String getResourceBundleName() {
        return this.bundleName;
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getSubstitutionData() {
        return this.subst;
    }

    public String toString() {
        Locale locale = Locale.getDefault();
        UserContext uc = UserContext.getCurrentUserContext();
        if (uc != null && uc.getLocale() != null) {
            locale = uc.getLocale();
        }
        return this.toString(locale);
    }

    public String toString(Locale locale) {
        String s;
        if (this.bundleName != null) {
            s = CommonResourceBundle.getString(this.bundleName, locale, this.key);
            if (this.subst != null) {
                s = MessageFormat.format(s, this.subst);
            }
        } else {
            s = this.key;
            if (this.subst != null) {
                s = MessageFormat.format(s, this.subst);
            }
        }
        return s;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalizableText) {
            LocalizableText text = (LocalizableText)obj;
            if (this.bundleName != null ? !this.bundleName.equals(text.bundleName) : text.bundleName != null) {
                return false;
            }
            if (this.key != null ? !this.key.equals(text.key) : text.key != null) {
                return false;
            }
            if (this.subst != null) {
                if (this.subst.length != text.subst.length) {
                    return false;
                }
                int i = 0;
                while (i < this.subst.length) {
                    if (!this.subst[i].equals(text.subst[i])) {
                        return false;
                    }
                    ++i;
                }
            } else if (text.subst != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        if (this.bundleName != null) {
            hash ^= this.bundleName.hashCode();
        }
        if (this.key != null) {
            hash ^= this.key.hashCode();
        }
        int i = 0;
        while (this.subst != null && i < this.subst.length) {
            hash ^= this.subst[i].hashCode();
            ++i;
        }
        return hash;
    }

    public Object clone() {
        LocalizableText result;
        block3: {
            result = null;
            try {
                result = (LocalizableText)super.clone();
                result.bundleName = this.bundleName;
                result.key = this.key;
                if (this.subst == null) {
                    result.subst = null;
                    break block3;
                }
                result.subst = new Object[this.subst.length];
                System.arraycopy(this.subst, 0, result.subst, 0, this.subst.length);
            }
            catch (CloneNotSupportedException exc) {
                exc.printStackTrace();
            }
        }
        return result;
    }

    public void toXML(StringBuffer sb) {
        sb.append("<localizableText class=\"" + this.getClass().getName() + "\"");
        if (this.bundleName != null) {
            sb.append(" bundle=\"");
            sb.append(this.bundleName);
            sb.append("\"");
        }
        if (this.key != null) {
            sb.append(" key=\"");
            sb.append(this.key);
            sb.append("\"");
        }
        sb.append(">");
        sb.append(this);
        if (this.subst != null) {
            sb.append("<list name=\"substitution\" class=\"" + this.subst.getClass().getName() + "\">");
            int i = 0;
            while (i < this.subst.length) {
                sb.append("<element class=\"" + this.subst[i].getClass().getName() + "\">");
                if (this.subst[i] instanceof XMLEncodeable) {
                    ((XMLEncodeable)this.subst[i]).toXML(sb);
                } else {
                    sb.append(this.subst[i].toString());
                }
                sb.append("</element>");
                ++i;
            }
            sb.append("</list>");
        }
        sb.append("</localizableText>");
    }

    public void fromXML(Node node) {
        Node workNode = XMLHelper.getWorkSection(node, "localizableText");
        String fromBundleName = XMLHelper.getAttributeValue(workNode, "bundle");
        String fromKey = XMLHelper.getAttributeValue(workNode, "key");
        if (fromBundleName != null) {
            this.setBundleName(fromBundleName);
        }
        if (fromKey != null) {
            this.setKey(fromKey);
        }
        if ((workNode = XMLHelper.getWorkSection(workNode, "list")) != null) {
            Object[] tempObjs = new Object[workNode.getChildNodes().getLength()];
            int elemCount = 0;
            int i = 0;
            while (i < workNode.getChildNodes().getLength()) {
                if (workNode.getChildNodes().item(i).getNodeName().equals("element")) {
                    try {
                        Class<?> elemClass = Class.forName(XMLHelper.getAttributeValue(workNode.getChildNodes().item(i), "class"));
                        Object elemObj = elemClass.newInstance();
                        if (elemObj instanceof XMLEncodeable) {
                            XMLEncodeable workObj = (XMLEncodeable)elemObj;
                            workObj.fromXML(workNode.getChildNodes().item(i));
                        } else {
                            elemObj = XMLHelper.getRealValue(workNode.getChildNodes().item(i));
                        }
                        tempObjs[elemCount] = elemObj;
                        ++elemCount;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            if (tempObjs.length > 0) {
                this.setSubst(tempObjs);
            }
        }
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public Object[] getSubst() {
        return this.subst;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSubst(Object[] subst) {
        this.subst = subst;
    }

    public static void main(String[] args) {
        try {
            LocalizableText lt = new LocalizableText("test");
            StringBuffer sb = new StringBuffer();
            XMLHelper.outToXML(lt, sb, lt.getClass());
            String origXML = sb.toString();
            System.out.println("******\nout>>" + origXML);
            System.out.println("<<out\n******");
            LocalizableText rbLt = (LocalizableText)XMLHelper.rebuildObject(origXML, "*");
            sb = new StringBuffer();
            XMLHelper.outToXML(rbLt, sb, rbLt.getClass());
            String rbXML = sb.toString();
            System.out.println("******\nrebuilt>>" + rbXML);
            System.out.println("<<rebuilt\n******");
            System.out.println("rb toString=" + rbLt.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

